unit UColunas;

interface

uses
  System.Drawing, System.Collections, System.ComponentModel,
  System.Windows.Forms, System.Data, ZedGraph, System.Globalization;

type
  TFrmColunas = class(System.Windows.Forms.Form)
  {$REGION 'Designer Managed Code'}
  strict private
    /// <summary>
    /// Required designer variable.
    /// </summary>
    Components: System.ComponentModel.Container;
    ZedGraphControl1: ZedGraph.ZedGraphControl;
    /// <summary>
    /// Required method for Designer support - do not modify
    /// the contents of this method with the code editor.
    /// </summary>
    procedure InitializeComponent;
    procedure TFrmColunas_Load(sender: System.Object; e: System.EventArgs);
  {$ENDREGION}
  strict protected
    /// <summary>
    /// Clean up any resources being used.
    /// </summary>
    procedure Dispose(Disposing: Boolean); override;
  private
    { Private Declarations }
  public
    EmColunas: Boolean;
    constructor Create;
  end;

  [assembly: RuntimeRequiredAttribute(TypeOf(TFrmColunas))]

implementation

{$AUTOBOX ON}

{$REGION 'Windows Form Designer generated code'}
/// <summary>
/// Required method for Designer support -- do not modify
/// the contents of this method with the code editor.
/// </summary>
procedure TFrmColunas.InitializeComponent;
begin
  Self.ZedGraphControl1 := ZedGraph.ZedGraphControl.Create;
  Self.SuspendLayout;
  // 
  // ZedGraphControl1
  // 
  Self.ZedGraphControl1.Anchor := (System.Windows.Forms.AnchorStyles((((System.Windows.Forms.AnchorStyles.Top 
    or System.Windows.Forms.AnchorStyles.Bottom) or System.Windows.Forms.AnchorStyles.Left) 
    or System.Windows.Forms.AnchorStyles.Right)));
  Self.ZedGraphControl1.CultureInfo := System.Globalization.CultureInfo.Create('p' +
    't-BR');
  Self.ZedGraphControl1.IsAutoScrollRange := False;
  Self.ZedGraphControl1.IsEnableHPan := True;
  Self.ZedGraphControl1.IsEnableVPan := True;
  Self.ZedGraphControl1.IsEnableZoom := True;
  Self.ZedGraphControl1.IsScrollY2 := False;
  Self.ZedGraphControl1.IsShowContextMenu := True;
  Self.ZedGraphControl1.IsShowHScrollBar := False;
  Self.ZedGraphControl1.IsShowPointValues := False;
  Self.ZedGraphControl1.IsShowVScrollBar := False;
  Self.ZedGraphControl1.IsZoomOnMouseCenter := False;
  Self.ZedGraphControl1.Location := System.Drawing.Point.Create(8, 16);
  Self.ZedGraphControl1.Name := 'ZedGraphControl1';
  Self.ZedGraphControl1.PanButtons := System.Windows.Forms.MouseButtons.Left;
  Self.ZedGraphControl1.PanButtons2 := System.Windows.Forms.MouseButtons.Middle;
  Self.ZedGraphControl1.PanModifierKeys2 := System.Windows.Forms.Keys.None;
  Self.ZedGraphControl1.PointDateFormat := 'g';
  Self.ZedGraphControl1.PointValueFormat := 'G';
  Self.ZedGraphControl1.ScrollMaxX := 0;
  Self.ZedGraphControl1.ScrollMaxY := 0;
  Self.ZedGraphControl1.ScrollMaxY2 := 0;
  Self.ZedGraphControl1.ScrollMinX := 0;
  Self.ZedGraphControl1.ScrollMinY := 0;
  Self.ZedGraphControl1.ScrollMinY2 := 0;
  Self.ZedGraphControl1.Size := System.Drawing.Size.Create(608, 296);
  Self.ZedGraphControl1.TabIndex := 0;
  Self.ZedGraphControl1.ZoomButtons := System.Windows.Forms.MouseButtons.Left;
  Self.ZedGraphControl1.ZoomButtons2 := System.Windows.Forms.MouseButtons.None;
  Self.ZedGraphControl1.ZoomModifierKeys := System.Windows.Forms.Keys.None;
  Self.ZedGraphControl1.ZoomModifierKeys2 := System.Windows.Forms.Keys.None;
  Self.ZedGraphControl1.ZoomStepFraction := 0.100000001490116;
  // 
  // TFrmColunas
  // 
  Self.AutoScaleBaseSize := System.Drawing.Size.Create(5, 13);
  Self.ClientSize := System.Drawing.Size.Create(632, 326);
  Self.Controls.Add(Self.ZedGraphControl1);
  Self.Name := 'TFrmColunas';
  Self.ShowInTaskbar := False;
  Self.StartPosition := System.Windows.Forms.FormStartPosition.CenterScreen;
  Self.Text := 'WinForm';
  Self.WindowState := System.Windows.Forms.FormWindowState.Maximized;
  Include(Self.Load, Self.TFrmColunas_Load);
  Self.ResumeLayout(False);
end;
{$ENDREGION}

procedure TFrmColunas.Dispose(Disposing: Boolean);
begin
  if Disposing then
  begin
    if Components <> nil then
      Components.Dispose();
  end;
  inherited Dispose(Disposing);
end;

constructor TFrmColunas.Create;
begin
  inherited Create;
  //
  // Required for Windows Form Designer support
  //
  InitializeComponent;
  //
  // TODO: Add any constructor code after InitializeComponent call
  //
end;

procedure TFrmColunas.TFrmColunas_Load(sender: System.Object; e: System.EventArgs);

{As constantes declaradas so vetores que armazenam
os rtulos (labels) para as colunas, os valores em percentuais
de pessoas e o grau de satisfao das pessoas em cada
atividade de entretenimento.}
const
   labels: array [1..6] of string =
       ('Cinema', 'Teatro', 'Televiso', 'Leitura', 'Esportes','Internet');
   percentual_satisfacao: array [1..6] of real =
       (80, 70, 50, 90, 60, 70);
   percentual_pessoas: array [1..6] of real =
       (50, 20, 95, 40, 60, 30);



var
  Barras: array [1..2] of BarItem;
  AxiValores, AxiLabels: Axis;
  X1, X2, Y1, Y2: array of real;

{A varivel Barras  um vetor de duas posies, do tipo
BarItem, que ser utilizada para armazenar as barras
criadas no grfico, permitindo que sejam feitas
configuraes nas mesmas aps criadas.

As Axis num grficos so as partes perifricas deste,
onde so colocadas informaes como valores e rtulos.
As Axis principais utilizadas no componente ZedGraph
so a XAxis e a YAxis onde a primeira  a lateral inferior
do grfico (horizontal) e a segunda  a  lateral esquerda
(vertical). Num grfico de colunas (verticais), a YAxis mostra
os valores e a XAxis mostra os rtulos das colunas.
Num grfico de barras (horizontais), a YAxis mostra
os rtulos e a XAxis mostra os valores.

A varivel AxiValores  utilizada para se acessar
de uma forma mais fcil a Axi contendo os valores das barras,
seja esta a XAxis ou YAxis. A varivel AxiLabels  utilizada para se
acessar de uma forma mais fcil a Axis contendo os rtulos.
Assim, estas variveis foram declaradas como sendo da classe Axis,
a classe ancestral de XAxis e YAxis. Logo, uma varivel
da classe Axis pode ser tanto uma XAxis como uma YAxis.

As variveis X1, X2, Y1 e Y2 so utilizadas para facilitar
a passagem de parmetros para a funo que adiciona as barras
no grfico. Estas variveis e as da classe Axis foram necessrias
devido ao fato de estarmos tornando o cdigo compatvel
para a construo de grficos de barras e colunas.
Se o cdigo fosse para a construo de apenas um desses tipos
de grfico, as variveis citadas agora seriam desnecessrias.
Elas foram utilizadas para evitar a duplicao
de cdigo, quando o cdigo duplicado tem pouqussimas
variveis do cdigo original.
}

begin
    //Define o ttulo do grfico.
    ZedGraphControl1.GraphPane.Title :=
       'Grfico de ndice de satisfao por opo de entretenimento';
    {Coloca tracinhos na base das barras, entre cada conjunto de barras.
    Neste caso, como temos duas barras para cada rtulo (que no caso indica
    opes de entretenimento), o tracinho aparecer a cada duas barras.
    Se esta opo for igual a False, o tracinho ficar no meio
    do conjunto de barras.}
    ZedGraphControl1.GraphPane.XAxis.IsTicsBetweenLabels := true;

    //Desenhar o grfico em colunas (verticais).
    //A varivel EmColunas ser alterada no momento de mostrar o form.
    //A mesma foi declarada na seo Public do form.
    if EmColunas then
    begin
      {Sendo o grfico em colunas, estas devem ser desenhadas
      informando-se valores para a Axi Y (YAxis), assim,
      as variveis Y1 e Y2 recebero valores, e as variveis
      X1 e X2 no recebero nada.}
      y1:= percentual_satisfacao;
      y2:= percentual_pessoas;

      {Indica para o componente que as colunas devem
      ficar na base X (horizontal).}
      ZedGraphControl1.GraphPane.BarBase:= BarBase.X;
      {A varivel AxiValores recebe a Axi Y (YAxis)
      indicando que os valores estaro nesta Axi (vertical).}
      AxiValores:= ZedGraphControl1.GraphPane.YAxis;
      {A varivel AxiLabels recebe a Axi X (XAxis)
      indicando que os rtulos estaro nesta Axi (horizontal).}
      AxiLabels:= ZedGraphControl1.GraphPane.XAxis;
    end
    //Desenhar o grfico em barras (horizontais).
    else
    begin
      {Sendo o grfico em barras, estas devem ser desenhadas
      informando-se valores para a Axi X (XAxis), assim,
      as variveis X1 e X2 recebero valores, e as variveis
      Y1 e Y2 no recebero nada.}
      x1:= percentual_satisfacao;
      x2:= percentual_pessoas;

      {Indica para o componente que as barras devem
      ficar na base Y (vertical).}
      ZedGraphControl1.GraphPane.BarBase:= BarBase.Y;
      {A varivel AxiValores recebe a Axi X (XAxis)
      indicando que os valores estaro nesta Axi (horizontal).}
      AxiValores:= ZedGraphControl1.GraphPane.XAxis;
      {A varivel AxiLabels recebe a Axi Y (YAxis)
      indicando que os rtulos estaro nesta Axi (vertical).}
      AxiLabels:= ZedGraphControl1.GraphPane.YAxis;
    end;
    {A funo AddBar adiciona uma barra no grfico.
    O primeiro parmetro  o rtulo para a barra, o segundo  um
    vetor de Double (Real) que deve conter os valores para a Axi X,
    o terceiro  do mesmo tipo e deve conter os valores para a Axi Y
    e o ltimo  a cor da barra. A funo devolve um BarItem.
    No cdigo anterior,  verificado se o grfico  em
    colunas ou em barras. Se for em colunas, atribui-se valores
    apenas s variveis Y1 e Y2 (ficando os valores na vertical),
    se for em barras, atribui-se valores
    apenas s variveis X1 e X2 (ficando os valores na horizontal).
    }
    barras[1] :=
      ZedGraphControl1.GraphPane.AddBar(
        'Satisfao', x1, y1, Color.Red);
    barras[2] :=
      ZedGraphControl1.GraphPane.AddBar(
        'Pessoas que Utilizam', x2, y2, Color.Blue);

    {A Axi contendo os valores pode ser a XAxis ou YAxis.
    A varivel AxiValores recebe uma destas.
    Da mesma forma acontece com a AxiLabels.
    Isto foi definido no cdigo mais acima. }
    //Define o valor mnimo para exibio na escala.
    AxiValores.Min := 0;
    //Define o valor mximo para exibio na escala.
    AxiValores.Max := 100;
    //Define o incremento da escala.
    //Estes trs valores, se no forem alterados, so configurados automaticamente
    AxiValores.Step := 10;
    //Ttulo da Axi contendo os valores
    AxiValores.Title:= 'Valores percentuais';
    //Ttulo da Axi contendo os labels
    AxiLabels.Title:= 'Opo de Entretenimento';
    //Atribui a lista de strings a serem exibidas na Axi dos labels
    AxiLabels.TextLabels := labels;
    {Informa que a Axi dos labels deve exibir texto ao invs de
    exibir valores. A propriedade Type est precedida de um & pois, como,
    Type  uma palavra reservada, nas verses anteriores do Delphi
    ela no poderia ser utilizada como nome de identificador. Porm,
    no Delphi 2005 isto  possvel utilizando-se um & antes do nome.}
    AxiLabels.&Type := AxisType.Text;

    {Define a cor das barras utilizando efeito gradiente.}
    barras[1].Bar.Fill :=
       Fill.create(Color.Red, Color.White, Color.Red);
    barras[2].Bar.Fill :=
       Fill.create(Color.Blue, Color.White, Color.Blue);

    //Define a cor de fundo do painel das Axis.
    ZedGraphControl1.GraphPane.AxisFill :=
       Fill.Create(Color.White, Color.LightBlue, 180);
    //Define a cor de fundo de todo o grfico.
    ZedGraphControl1.GraphPane.PaneFill :=
       Fill.Create(Color.White);

    //Atualiza o grfico aps todas as modificaes feitas.
    ZedGraphControl1.GraphPane.AxisChange(CreateGraphics);
end;

end.
